//+------------------------------------------------------------------+
//|                                 Stoch Candle OverBought-Sold.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//+------------------------------------------------------------------+
//|                                                 StochCandles.mq4 |
//| Colored Candles, based on Stochastic Signal.							|
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Christof Risch (iya)"
#property link      "http://www.forexfactory.com/showthread.php?t=13321"
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Lime
#property indicator_color2 Red
#property indicator_color3 Lime
#property indicator_color4 Red
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 3
#property indicator_width4 3

#property indicator_color5 Orange
#property indicator_color6 Orange
#property indicator_color7 Orange
#property indicator_color8 Orange
#property indicator_width5 1
#property indicator_width6 1
#property indicator_width7 3
#property indicator_width8 3

//---- stoch settings
extern string note1 = "Stochastic settings";
extern double	Stoch_K			= 30.0,
					Stoch_D			= 10.0,
					Stoch_Slowing	= 10.0,
					Upper_Level		= 80,
					Lower_Level		= 20;

//---- input parameters
extern color	BarUp				= Lime,
					BarDown			= Red,
					BullCandle		= Lime,
					BearCandle		= Red,
					BarUp2			= Yellow,
					BarDown2			= Orange,
					MedCandle      = Yellow,
					MedCandle2     = Orange;
extern int		BarWidth			= 1,
					CandleWidth		= 3,
					BarWidth2		= 1,
					CandleWidth2	= 3;

//---- buffers
double Buffer1[];
double Buffer2[];
double Buffer3[];
double Buffer4[];
double Buffer5[];
double Buffer6[];
double Buffer7[];
double Buffer8[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
	SetIndexStyle(0,DRAW_HISTOGRAM,0,BarWidth,BarUp);
	SetIndexStyle(1,DRAW_HISTOGRAM,0,BarWidth,BarDown);
	SetIndexStyle(2,DRAW_HISTOGRAM,0,CandleWidth,BullCandle);
	SetIndexStyle(3,DRAW_HISTOGRAM,0,CandleWidth,BearCandle);
	SetIndexBuffer(0, Buffer1);
	SetIndexBuffer(1, Buffer2);
	SetIndexBuffer(2, Buffer3);
	SetIndexBuffer(3, Buffer4);
	
	SetIndexStyle(4,DRAW_HISTOGRAM,0,BarWidth2,BarUp2);
	SetIndexStyle(5,DRAW_HISTOGRAM,0,BarWidth2,BarDown2);
	SetIndexStyle(6,DRAW_HISTOGRAM,0,CandleWidth2,MedCandle );
	SetIndexStyle(7,DRAW_HISTOGRAM,0,CandleWidth2,MedCandle2 );
	SetIndexBuffer(4, Buffer5);
	SetIndexBuffer(5, Buffer6);
	SetIndexBuffer(6, Buffer7);
	SetIndexBuffer(7, Buffer8);
	return(0);
}

//+------------------------------------------------------------------+
double Stoch_Main  	(int i = 0)	{return(iStochastic(NULL,0,Stoch_K,Stoch_D,Stoch_Slowing,MODE_SMA,0,MODE_MAIN,  i));}
//double Stoch_Signal	(int i = 0)	{return(iStochastic(NULL,0,Stoch_K,Stoch_D,Stoch_Slowing,MODE_SMA,0,MODE_SIGNAL,i));}
//+------------------------------------------------------------------+
bool IsMedCandle(int i = 0)
{
	if(i>=Bars)
		return(false);

	if(High[i]==Low[i])
		return(IsMedCandle(i+1));

	return(Buffer5[i]==High[i] && Buffer6[i]==Low[i]);
}

//+------------------------------------------------------------------+
void SetBullCandle(int i = 0)
{
	Buffer1[i] = High[i];
	Buffer2[i] = Low[i];
	Buffer3[i] = MathMax(Open[i],Close[i]);
	Buffer4[i] = MathMin(Open[i],Close[i]);
}

//+------------------------------------------------------------------+
void SetBearCandle(int i = 0)
{
	Buffer1[i] = Low[i];
	Buffer2[i] = High[i];
	Buffer3[i] = MathMin(Open[i],Close[i]);
	Buffer4[i] = MathMax(Open[i],Close[i]);
}
//+------------------------------------------------------------------+
void SetMedCandle(int i = 0)
{
	Buffer5[i] = Low[i];
	Buffer6[i] = High[i];
	Buffer7[i] = MathMin(Open[i],Close[i]);
	Buffer8[i] = MathMax(Open[i],Close[i]);
}

//+------------------------------------------------------------------+
void SetMedCandle2(int i = 0)
{
	Buffer5[i] = Low[i];
	Buffer6[i] = High[i];
	Buffer7[i] = MathMin(Open[i],Close[i]);
	Buffer8[i] = MathMax(Open[i],Close[i]);
}


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
	for(int i = MathMax(Bars-1-IndicatorCounted(),1); i >= 0; i--)
	{
//		bool		bull = Close[i] > Open[i],
//					bear = Close[i] < Open[i];
		double	stochMain	= Stoch_Main(i),
				
					Med = Stoch_Main(i);
					
		bool		bull = (stochMain < Lower_Level),
				bear = (stochMain > Upper_Level	);
					Med =  ((stochMain < Upper_Level	)&&(stochMain > 20));


		if(!bull && !bear && !Med)
		{
				bull = (stochMain < Lower_Level);
			bear = (stochMain > Upper_Level	);
			Med =  ((stochMain < Upper_Level	)&&(stochMain > Lower_Level));
		}

		if			(bull)					SetBullCandle(i);
		else if	(bear)					SetBearCandle(i);
		
		else if	(IsMedCandle(i+1))	SetMedCandle(i);
		else									SetMedCandle2(i);
	}

	return(0);
}
//+------------------------------------------------------------------+

